/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rendering;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.google.inject.Inject;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.mapping.tile.floor.CellFloor;
import technology.rocketjump.undermount.mapping.tile.wall.Wall;
import technology.rocketjump.undermount.rendering.RenderMode;
import technology.rocketjump.undermount.rendering.custom_libgdx.VertexColorSpriteBatch;
import technology.rocketjump.undermount.sprites.TerrainSpriteCache;
import technology.rocketjump.undermount.sprites.model.QuadrantSprites;

public class TerrainRenderer {
    private final float WALL_QUADRANT_MIDPOINT_X = 0.5f;
    private final float WALL_QUADRANT_MIDPOINT_Y = 0.78125f;
    private final float TILE_WIDTH_HEIGHT = 1.0f;
    private final float QUADRANT_A_B_HEIGHT = 0.21875f;
    private final float QUADRANT_C_D_HEIGHT = 0.78125f;

    @Inject
    public TerrainRenderer() {
    }

    public void render(MapTile mapTile, int worldX, int worldY, VertexColorSpriteBatch vertexColorSpriteBatch, TerrainSpriteCache spriteCache, RenderMode renderMode) {
        if (renderMode.equals((Object)RenderMode.DIFFUSE)) {
            this.setColor(vertexColorSpriteBatch, mapTile);
        }
        if (mapTile.hasWall()) {
            QuadrantSprites quadrantSprites = spriteCache.getSpritesForWall(mapTile.getWall().getWallType(), mapTile.getWall().getTrueLayout(), mapTile.getSeed());
            if (quadrantSprites.isSingleSprite()) {
                vertexColorSpriteBatch.draw(quadrantSprites.getA(), (float)worldX, (float)worldY, 1.0f, 1.0f);
            } else {
                this.renderWallQuadrants(worldX, worldY, vertexColorSpriteBatch, quadrantSprites);
            }
            if (mapTile.getWall().hasOre()) {
                QuadrantSprites oreSpritesForWall;
                if (renderMode.equals((Object)RenderMode.DIFFUSE)) {
                    this.setColor(vertexColorSpriteBatch, mapTile.getWall().getOreMaterial());
                }
                if ((oreSpritesForWall = spriteCache.getSpritesForWall(mapTile.getWall().getOreType(), mapTile.getWall().getTrueLayout(), mapTile.getSeed())).isSingleSprite()) {
                    vertexColorSpriteBatch.draw(oreSpritesForWall.getA(), (float)worldX, (float)worldY, 1.0f, 1.0f);
                } else {
                    this.renderWallQuadrants(worldX, worldY, vertexColorSpriteBatch, oreSpritesForWall);
                }
            }
        } else {
            Sprite spriteForFloor = spriteCache.getFloorSpriteForType(mapTile.getFloor().getFloorType(), mapTile.getSeed());
            if (renderMode.equals((Object)RenderMode.DIFFUSE)) {
                vertexColorSpriteBatch.draw(spriteForFloor, worldX, worldY, 1.0f, 1.0f, mapTile.getFloor().getVertexColors());
            } else {
                vertexColorSpriteBatch.draw(spriteForFloor, (float)worldX, (float)worldY, 1.0f, 1.0f);
            }
        }
    }

    private void setColor(VertexColorSpriteBatch spriteBatch, GameMaterial material) {
        if (material.getColor() != null) {
            spriteBatch.setColor(material.getColor());
        }
    }

    private void setColor(VertexColorSpriteBatch spriteBatch, MapTile mapTile) {
        if (mapTile.hasWall()) {
            Wall wall = mapTile.getWall();
            if (wall.getWallType().isUseMaterialColor() && wall.getMaterial().getColor() != null) {
                spriteBatch.setColor(wall.getMaterial().getColor());
            } else {
                spriteBatch.setColor(Color.WHITE);
            }
        } else {
            CellFloor floor = mapTile.getFloor();
            if (floor.getFloorType().isUseMaterialColor() && floor.getMaterial().getColor() != null) {
                spriteBatch.setColor(floor.getMaterial().getColor());
            } else {
                spriteBatch.setColor(Color.WHITE);
            }
        }
    }

    private void renderWallQuadrants(int worldX, int worldY, VertexColorSpriteBatch vertexColorSpriteBatch, QuadrantSprites spritesForWall) {
        vertexColorSpriteBatch.draw(spritesForWall.getA().getTexture(), worldX, (float)worldY + 0.78125f, 0.25f, 0.109375f, 0.5f, 0.21875f, spritesForWall.getA().getScaleX(), spritesForWall.getA().getScaleY(), 0.0f, spritesForWall.getA().getRegionX(), spritesForWall.getA().getRegionY(), spritesForWall.getA().getRegionWidth() - 32, spritesForWall.getA().getRegionHeight() - 50, false, false);
        vertexColorSpriteBatch.draw(spritesForWall.getB().getTexture(), (float)worldX + 0.5f, (float)worldY + 0.78125f, 0.25f, 0.109375f, 0.5f, 0.21875f, spritesForWall.getB().getScaleX(), spritesForWall.getB().getScaleY(), 0.0f, spritesForWall.getB().getRegionX() + 32, spritesForWall.getB().getRegionY(), spritesForWall.getB().getRegionWidth() - 32, spritesForWall.getB().getRegionHeight() - 50, false, false);
        vertexColorSpriteBatch.draw(spritesForWall.getC().getTexture(), worldX, worldY, 0.25f, 0.390625f, 0.5f, 0.78125f, spritesForWall.getC().getScaleX(), spritesForWall.getC().getScaleY(), 0.0f, spritesForWall.getC().getRegionX(), spritesForWall.getC().getRegionY() + 16, spritesForWall.getC().getRegionWidth() - 32, spritesForWall.getC().getRegionHeight() - 16, false, false);
        vertexColorSpriteBatch.draw(spritesForWall.getD().getTexture(), (float)worldX + 0.5f, worldY, 0.25f, 0.390625f, 0.5f, 0.78125f, spritesForWall.getD().getScaleX(), spritesForWall.getD().getScaleY(), 0.0f, spritesForWall.getD().getRegionX() + 32, spritesForWall.getD().getRegionY() + 16, spritesForWall.getD().getRegionWidth() - 32, spritesForWall.getD().getRegionHeight() - 16, false, false);
    }
}

